package com.example.myapplication

import android.app.Activity
import android.view.*
import androidx.appcompat.widget.SearchView
import androidx.appcompat.widget.SearchView.OnQueryTextListener

class SearchHolder(private val activity: Activity) {
    var searchMenuItem: MenuItem? = null
    var searchView: SearchView? = null

    //    private fun isCurrentlyExpanded(): Boolean = searchMenuItem?.isActionViewExpanded == true
    fun getQuery(): String? {
        if (searchMenuItem == null || searchView == null || !searchMenuItem!!.isActionViewExpanded)
            return null
        val query = searchView!!.query
        return query?.toString()
    }

    fun hasQuery(): Boolean =
        searchMenuItem?.isActionViewExpanded == true && !searchView?.query.isNullOrEmpty()

    /**returns true if was opened and now got closed */
    fun collapse(): Boolean {
        val searchMenuItem = searchMenuItem ?: return false
        return searchMenuItem.isActionViewExpanded && searchMenuItem.collapseActionView()
    }

    fun init(
        searchMenuItem: MenuItem,
        hintResId: Int,
        onQueryTextListener: OnQueryTextListener?,
        onActionExpandListener: MenuItem.OnActionExpandListener?
    ) {
        this.searchMenuItem = searchMenuItem
        if (searchView != null) {
            searchView.removeFromParent()
            this.searchMenuItem!!.actionView = searchView
        } else {
            searchView = searchMenuItem.actionView as SearchView
            if (searchView == null) {
                searchMenuItem.setShowAsAction(MenuItem.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW or MenuItem.SHOW_AS_ACTION_ALWAYS)
                searchView = SearchView(activity)
                searchMenuItem.actionView = searchView
            }
            searchView!!.queryHint = activity.getString(hintResId)
        }
        searchMenuItem.setOnActionExpandListener(onActionExpandListener)
        searchView!!.setOnQueryTextListener(onQueryTextListener)
    }
}
