package com.example.myapplication

import android.app.Activity
import android.view.*
import androidx.fragment.app.*

fun DialogFragment.showAllowStateLoss(fragment: Fragment, tag: String? = null) =
    fragment.childFragmentManager.beginTransaction().add(this, tag).commitAllowingStateLoss() >= 0

fun Fragment.isNotAddedOrActivityFinishingOrDestroyed() =
    !isAdded || isActivityFinishingOrDestroyed()

fun Fragment.isActivityFinishingOrDestroyed(): Boolean = activity.isFinishedOrFinishing()
fun Activity?.isFinishedOrFinishing(): Boolean =
    this == null || isFinishing || isDestroyed

fun View?.removeFromParent() =
    (this?.parent as? ViewGroup?)?.removeView(this)

object Utils {
}
