package com.example.myapplication

import android.content.Context
import android.net.*
import android.os.*
import android.util.Log
import androidx.appcompat.app.AppCompatActivity

class MainActivity2 : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main2)
        Log.d("AppLog", "isInternetOn?${isInternetOn(this)}")
    }
    
    companion object{
        fun isInternetOn(context: Context): Boolean {
            val connectivityManager = context.getSystemService<ConnectivityManager>()
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                val allNetworks = connectivityManager.allNetworks
                for (network in allNetworks) {
                    val networkCapabilities = connectivityManager.getNetworkCapabilities(network)
                        ?: continue
                    if (networkCapabilities.hasCapability(NetworkCapabilities.NET_CAPABILITY_INTERNET))
                        return true
                }
                return false
            } else {
                @Suppress("DEPRECATION") val allNetworkInfo = connectivityManager.allNetworkInfo
                for (networkInfo in allNetworkInfo) {
                    @Suppress("DEPRECATION")
                    if (networkInfo.isConnected)
                        return true
                }
            }
            return false
        }
    }
}
