package com.ytheekshana.languagetest

import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.app.AppCompatDelegate
import androidx.core.os.LocaleListCompat
import com.google.android.material.button.MaterialButton

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)


        val btnSpanish: MaterialButton = findViewById(R.id.btnSpanish)
        val btnRussian: MaterialButton = findViewById(R.id.btnRussian)
        val btnArabic: MaterialButton = findViewById(R.id.btnArabic)
        val btnDefault: MaterialButton = findViewById(R.id.btnDefault)
        val btnFirstActivity: MaterialButton = findViewById(R.id.btnFirstActivity)
        val btnSecondActivity: MaterialButton = findViewById(R.id.btnSecondActivity)

        btnFirstActivity.setOnClickListener {
            val intent = Intent(this@MainActivity, FirstActivity::class.java)
            startActivity(intent)
        }

        btnSecondActivity.setOnClickListener {
            val intent = Intent(this@MainActivity, SecondActivity::class.java)
            startActivity(intent)
        }

        btnSpanish.setOnClickListener {
            val appLocale = LocaleListCompat.forLanguageTags("es")
            AppCompatDelegate.setApplicationLocales(appLocale)
        }
        btnRussian.setOnClickListener {
            val appLocale = LocaleListCompat.forLanguageTags("ru")
            AppCompatDelegate.setApplicationLocales(appLocale)
        }
        btnArabic.setOnClickListener {
            val appLocale = LocaleListCompat.forLanguageTags("ar")
            AppCompatDelegate.setApplicationLocales(appLocale)
        }
        btnDefault.setOnClickListener {
            val appLocale = LocaleListCompat.getEmptyLocaleList()
            AppCompatDelegate.setApplicationLocales(appLocale)
        }


    }
}