package com.example.crashdemo;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomOpenHelper;
import androidx.room.RoomOpenHelper.Delegate;
import androidx.room.RoomOpenHelper.ValidationResult;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.FtsTableInfo;
import androidx.room.util.TableInfo;
import androidx.room.util.TableInfo.Column;
import androidx.room.util.TableInfo.ForeignKey;
import androidx.room.util.TableInfo.Index;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteOpenHelper.Callback;
import androidx.sqlite.db.SupportSQLiteOpenHelper.Configuration;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressWarnings({"unchecked", "deprecation"})
public final class MyDatabase_Impl extends MyDatabase {
  @Override
  protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(3) {
      @Override
      public void createAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("CREATE TABLE IF NOT EXISTS `my_entity` (`text` TEXT NOT NULL, `second_text` TEXT NOT NULL, `third_text` TEXT NOT NULL, `_id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
        _db.execSQL("CREATE VIRTUAL TABLE IF NOT EXISTS `my_fts_entity` USING FTS4(`text` TEXT NOT NULL, content=`my_entity`)");
        _db.execSQL("CREATE TRIGGER IF NOT EXISTS room_fts_content_sync_my_fts_entity_BEFORE_UPDATE BEFORE UPDATE ON `my_entity` BEGIN DELETE FROM `my_fts_entity` WHERE `docid`=OLD.`rowid`; END");
        _db.execSQL("CREATE TRIGGER IF NOT EXISTS room_fts_content_sync_my_fts_entity_BEFORE_DELETE BEFORE DELETE ON `my_entity` BEGIN DELETE FROM `my_fts_entity` WHERE `docid`=OLD.`rowid`; END");
        _db.execSQL("CREATE TRIGGER IF NOT EXISTS room_fts_content_sync_my_fts_entity_AFTER_UPDATE AFTER UPDATE ON `my_entity` BEGIN INSERT INTO `my_fts_entity`(`docid`, `text`) VALUES (NEW.`rowid`, NEW.`text`); END");
        _db.execSQL("CREATE TRIGGER IF NOT EXISTS room_fts_content_sync_my_fts_entity_AFTER_INSERT AFTER INSERT ON `my_entity` BEGIN INSERT INTO `my_fts_entity`(`docid`, `text`) VALUES (NEW.`rowid`, NEW.`text`); END");
        _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'a1b99fcc83cd77cc3b9e216bb858dc0a')");
      }

      @Override
      public void dropAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("DROP TABLE IF EXISTS `my_entity`");
        _db.execSQL("DROP TABLE IF EXISTS `my_fts_entity`");
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onDestructiveMigration(_db);
          }
        }
      }

      @Override
      public void onCreate(SupportSQLiteDatabase _db) {
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onCreate(_db);
          }
        }
      }

      @Override
      public void onOpen(SupportSQLiteDatabase _db) {
        mDatabase = _db;
        internalInitInvalidationTracker(_db);
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onOpen(_db);
          }
        }
      }

      @Override
      public void onPreMigrate(SupportSQLiteDatabase _db) {
        DBUtil.dropFtsSyncTriggers(_db);
      }

      @Override
      public void onPostMigrate(SupportSQLiteDatabase _db) {
        _db.execSQL("CREATE TRIGGER IF NOT EXISTS room_fts_content_sync_my_fts_entity_BEFORE_UPDATE BEFORE UPDATE ON `my_entity` BEGIN DELETE FROM `my_fts_entity` WHERE `docid`=OLD.`rowid`; END");
        _db.execSQL("CREATE TRIGGER IF NOT EXISTS room_fts_content_sync_my_fts_entity_BEFORE_DELETE BEFORE DELETE ON `my_entity` BEGIN DELETE FROM `my_fts_entity` WHERE `docid`=OLD.`rowid`; END");
        _db.execSQL("CREATE TRIGGER IF NOT EXISTS room_fts_content_sync_my_fts_entity_AFTER_UPDATE AFTER UPDATE ON `my_entity` BEGIN INSERT INTO `my_fts_entity`(`docid`, `text`) VALUES (NEW.`rowid`, NEW.`text`); END");
        _db.execSQL("CREATE TRIGGER IF NOT EXISTS room_fts_content_sync_my_fts_entity_AFTER_INSERT AFTER INSERT ON `my_entity` BEGIN INSERT INTO `my_fts_entity`(`docid`, `text`) VALUES (NEW.`rowid`, NEW.`text`); END");
      }

      @Override
      public RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
        final HashMap<String, TableInfo.Column> _columnsMyEntity = new HashMap<String, TableInfo.Column>(4);
        _columnsMyEntity.put("text", new TableInfo.Column("text", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMyEntity.put("second_text", new TableInfo.Column("second_text", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMyEntity.put("third_text", new TableInfo.Column("third_text", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMyEntity.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysMyEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesMyEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoMyEntity = new TableInfo("my_entity", _columnsMyEntity, _foreignKeysMyEntity, _indicesMyEntity);
        final TableInfo _existingMyEntity = TableInfo.read(_db, "my_entity");
        if (! _infoMyEntity.equals(_existingMyEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "my_entity(com.example.crashdemo.MyEntity).\n"
                  + " Expected:\n" + _infoMyEntity + "\n"
                  + " Found:\n" + _existingMyEntity);
        }
        final HashSet<String> _columnsMyFtsEntity = new HashSet<String>(1);
        _columnsMyFtsEntity.add("text");
        final FtsTableInfo _infoMyFtsEntity = new FtsTableInfo("my_fts_entity", _columnsMyFtsEntity, "CREATE VIRTUAL TABLE IF NOT EXISTS `my_fts_entity` USING FTS4(`text` TEXT NOT NULL, content=`my_entity`)");
        final FtsTableInfo _existingMyFtsEntity = FtsTableInfo.read(_db, "my_fts_entity");
        if (!_infoMyFtsEntity.equals(_existingMyFtsEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "my_fts_entity(com.example.crashdemo.MyFtsEntity).\n"
                  + " Expected:\n" + _infoMyFtsEntity + "\n"
                  + " Found:\n" + _existingMyFtsEntity);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "a1b99fcc83cd77cc3b9e216bb858dc0a", "c2eb3a406b26ce21e4a55b98155f9ff6");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(configuration.context)
        .name(configuration.name)
        .callback(_openCallback)
        .build();
    final SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(1);
    _shadowTablesMap.put("my_fts_entity", "my_entity");
    HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "my_entity","my_fts_entity");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `my_entity`");
      _db.execSQL("DELETE FROM `my_fts_entity`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    return _typeConvertersMap;
  }

  @Override
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  public List<Migration> getAutoMigrations(
      @NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
    return Arrays.asList();
  }
}
