package com.example.crashdemo

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.room.Room
import androidx.room.migration.Migration
import androidx.sqlite.db.SupportSQLiteDatabase

class MainActivity : AppCompatActivity() {

    private val migrations: Array<Migration>
        get() = arrayOf(
            object : Migration(0, 1) {
                override fun migrate(database: SupportSQLiteDatabase) {
                }
            },
            object : Migration(1, 2) {
                override fun migrate(database: SupportSQLiteDatabase) {
                    database.execSQL("ALTER TABLE `my_entity` ADD COLUMN second_text TEXT NOT NULL;")
                }
            },
            object : Migration(2, 3) {
                override fun migrate(database: SupportSQLiteDatabase) {
                    database.execSQL("ALTER TABLE `my_entity` ADD COLUMN third_text TEXT NOT NULL;")
                }
            })

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        buildDatabase()
    }

    private fun buildDatabase() {
        Room.databaseBuilder(application, MyDatabase::class.java, "MyDatabase")
            .addMigrations(*migrations)
            .build()
    }
}