package me.jansv.ari

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import androidx.fragment.app.Fragment

class MainFragment : Fragment() {

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? = inflater.inflate(R.layout.fragment_main, container, false)

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        view.findViewById<Button>(R.id.button_start_act1).setOnClickListener {
            startActivityForResult(
                Intent(requireActivity(), ResultActivity1::class.java),
                ResultActivity1.REQUEST_CODE
            )
        }

        view.findViewById<Button>(R.id.button_start_act2).setOnClickListener {
            startActivityForResult(
                Intent(requireActivity(), ResultActivity2::class.java),
                ResultActivity2.REQUEST_CODE
            )
        }
    }

    override fun startActivityForResult(intent: Intent?, requestCode: Int) {
        Log.e("MainFragment", "startActivityForResult: ${intent?.component?.className}{requestCode=$requestCode}")
        super.startActivityForResult(intent, requestCode)
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        Log.e("MainFragment", "onActivityResult: requestCode=$requestCode, resultCode=$resultCode, extras=${data?.extras?.toMap()}")
    }
}
