package com.example.composedialogfragment

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.material.Button
import androidx.compose.material.Text
import androidx.compose.material.TextField
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.ComposeView
import androidx.compose.ui.unit.dp
import androidx.fragment.app.DialogFragment
import com.example.composedialogfragment.ui.theme.ComposeDialogFragmentTheme

class MainDialogFragment: DialogFragment() {

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val view = ComposeView(requireContext()).apply {
            setContent {
                ComposeDialogFragmentTheme {
                    Layout()
                }
            }
        }
        return view
    }

    @Composable
    fun Layout() {
        Column(horizontalAlignment = Alignment.CenterHorizontally) {
            var str by remember { mutableStateOf("") }
            TextField(value = str, onValueChange = { str = it } )
            Spacer(modifier = Modifier.height(10.dp))
            Button(onClick = {dismiss()}) {
                Text("Close")
            }
        }
    }
}
