package com.alonalbert.slowunderdebugger

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.lifecycle.coroutineScope
import com.alonalbert.slowunderdebugger.ui.theme.SlowUnderDebuggerTheme
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import java.util.Date
import java.util.concurrent.TimeUnit
import kotlin.math.sin
import kotlin.random.Random
import kotlin.system.measureNanoTime

private val random = Random(Date().time)

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            SlowUnderDebuggerTheme {
                Surface(modifier = Modifier.fillMaxSize(), color = MaterialTheme.colorScheme.background) {
                    var text by remember { mutableStateOf("") }
                    LaunchedEffect(key1 = "DoSomeWork") {
                        lifecycle.coroutineScope.launch {
                            while (true) {
                                val nanos = measureNanoTime { repeat(1_000_000) { sin(random.nextDouble()) } }
                                val millis = TimeUnit.NANOSECONDS.toMillis(nanos)
                                text = "Execution time: $millis ms"
                                delay(1_000)
                            }
                        }
                    }
                    Box(contentAlignment = Alignment.Center) {
                        Text(text, style = MaterialTheme.typography.headlineSmall)
                    }
                }
            }
        }
    }
}

