package com.andreirozov.sample.ui

import android.util.Log
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material3.*
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import androidx.navigation.NavGraph.Companion.findStartDestination
import androidx.navigation.NavHostController
import com.andreirozov.sample.utils.DrawerNavigationItem

// Drawer navigation routes
private val navigationItems = listOf(
    DrawerNavigationItem.Screen2,
    DrawerNavigationItem.Screen1,
)

@Composable
fun AppDrawer(currentRoute: String, navController: NavHostController, closeDrawer: () -> Unit) {
    ModalDrawerSheet(
        content = {
            // Drawer navigation items
            Column(
                modifier = Modifier
                    .verticalScroll(rememberScrollState())
                    .padding(8.dp),
                content = {
                    navigationItems.forEach { item ->
                        NavigationDrawerItem(
                            label = {
                                Text(text = stringResource(item.title))
                            },
                            icon = {
                                Icon(
                                    painter = painterResource(
                                        id = if (currentRoute == item.route) item.filledIcon else item.icon
                                    ),
                                    contentDescription = stringResource(item.title)
                                )
                            },
                            selected = currentRoute == item.route,
                            onClick = {
                                // If select not current screen, navigate to new screen and close drawer, otherwise only close drawer
                                if (currentRoute != item.route) {
                                    Log.d("Something", "navigating to ${item.route}")
                                    navController.navigate(item.route) {
                                        popUpTo(navController.graph.findStartDestination().id) {
                                            saveState = false
                                        }
                                        launchSingleTop = true
                                        restoreState = false
                                    }
                                }

                                closeDrawer()
                            }
                        )
                    }
                }
            )
        }
    )
}