package com.andreirozov.sample.ui.standings.screen2

import androidx.compose.foundation.*
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.foundation.lazy.rememberLazyListState
import androidx.compose.material3.*
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import androidx.hilt.navigation.compose.hiltViewModel
import androidx.lifecycle.compose.collectAsStateWithLifecycle

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun AnotherScreen(scrollBehavior: TopAppBarScrollBehavior) {
    // Get viewModel for league tab
    val leagueViewModel = hiltViewModel<Screen2TabViewModel>()

    // Subscribe to league tab state
    val leagueUiState by leagueViewModel.screen2TabUiState.collectAsStateWithLifecycle()

    when (leagueUiState) {
        is Screen2TabUiState.Loading -> LoadingState()
        is Screen2TabUiState.Success -> SuccessState(
            scrollBehavior = scrollBehavior
        )
    }
}

@Composable
private fun LoadingState() {
    Column(
        modifier = Modifier.fillMaxSize(),
        verticalArrangement = Arrangement.Center,
        horizontalAlignment = Alignment.CenterHorizontally,
        content = {
            CircularProgressIndicator()
        }
    )
}

@OptIn(ExperimentalMaterial3Api::class)
@Composable
private fun SuccessState(
    scrollBehavior: TopAppBarScrollBehavior
) {
    // List
    val list = List(60) { "some item" }

    // State of LazyColumn
    val listState = rememberLazyListState()

    LazyColumn(
        modifier = Modifier.fillMaxWidth(),
        state = listState,
        contentPadding = PaddingValues(bottom = 8.dp),
        verticalArrangement = Arrangement.spacedBy(8.dp),
        content = {
            items(items = list) {
                Card(
                    modifier = Modifier.fillMaxWidth(),
                    content = {
                        Text(text = it)
                    }
                )
            }
        }
    )
}

