package com.andreirozov.sample.ui.standings.screen2

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class Screen2TabViewModel @Inject constructor() : ViewModel() {
    private val _screen2TabUiState = MutableStateFlow<Screen2TabUiState>(Screen2TabUiState.Loading)
    val screen2TabUiState: StateFlow<Screen2TabUiState> = _screen2TabUiState.asStateFlow()

    // Use it to cancel not finished request job if we send new one
    private var fetchJob: Job? = null

    init {
        getTheData()
    }

    private fun getTheData() {
        // Set ui state to loading
        _screen2TabUiState.value = Screen2TabUiState.Loading

        // Cancel previous request job
        fetchJob?.cancel()

        fetchJob = viewModelScope.launch {

            delay(2000)

            // Change state for league tab
            _screen2TabUiState.value =
                Screen2TabUiState.Success
        }
    }
}