package nl.esites.emptytest

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.getValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import androidx.navigation.NavDestination.Companion.hierarchy
import androidx.navigation.NavGraph.Companion.findStartDestination
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.currentBackStackEntryAsState
import androidx.navigation.compose.rememberNavController
import nl.esites.emptytest.ui.theme.EmptyTestTheme


sealed class Screen(val route: String, val label: String) {
    object Screen1 : Screen("screen_1_route", "screen 1")
    object Screen2 : Screen("screen_2_route", "screen 2")
}

class MainActivity : ComponentActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            EmptyTestTheme {
                Surface(
                    modifier = Modifier.fillMaxSize(),
                    color = MaterialTheme.colors.background
                ) {
                    val items = listOf(Screen.Screen1, Screen.Screen2)
                    val navController = rememberNavController()

                    Column(
                        modifier = Modifier
                            .fillMaxSize()
                    ) {
                        NavHost(
                            navController = navController,
                            startDestination = Screen.Screen1.route,
                            modifier = Modifier
                                .fillMaxWidth()
                                .weight(1f)
                        ) {
                            composable(route = Screen.Screen1.route) {
                                Box(modifier = Modifier.fillMaxSize()) {
                                    Text(
                                        text = Screen.Screen1.label,
                                        modifier = Modifier.clickable {
                                            // REMOVING THIS LINE WILL "FIX" THE CRASH
                                            navController.popBackStack()
                                        }
                                    )
                                }
                            }
                            composable(route = Screen.Screen2.route) {
                                Box(modifier = Modifier.fillMaxSize()) {
                                    Text(
                                        text = Screen.Screen2.label,
                                    )
                                }
                            }
                        }

                        Row(
                            modifier = Modifier
                                .fillMaxWidth()
                                .height(72.dp)
                        ) {
                            val navBackStackEntry by navController.currentBackStackEntryAsState()
                            val currentDestination = navBackStackEntry?.destination

                            items.forEach { screen ->
                                val selected = currentDestination?.hierarchy?.any { it.route == screen.route } == true
                                Box(
                                    modifier = Modifier
                                        .fillMaxHeight()
                                        .weight(1f)
                                        .clickable {
                                            navController.navigate(screen.route) {
                                                popUpTo(navController.graph.findStartDestination().id)
                                                launchSingleTop = true
                                            }
                                        }
                                ) {
                                    Text(
                                        text = screen.label,
                                        color = if (selected) MaterialTheme.colors.primaryVariant else MaterialTheme.colors.onBackground,
                                        modifier = Modifier.align(Alignment.Center)
                                    )
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}