plugins {
    alias(libs.plugins.com.android.application)
    alias(libs.plugins.org.jetbrains.kotlin.android)
    kotlin("kapt")
}

android {
    compileSdk = 33
    namespace = "me.shikhov.basejar"
    buildToolsVersion = "33.0.2"

    defaultConfig {
        minSdk = 15
        targetSdk = 33
        resourceConfigurations += listOf("en", "ru", "pl", "in")
        versionCode = 1
        versionName = "1.0"

        testInstrumentationRunnerArguments["clearPackageData"] = "true"

        manifestPlaceholders["appAuthRedirectScheme"] ="me.shikhov.basejar"
    }

    testOptions {
        execution = "ANDROIDX_TEST_ORCHESTRATOR"
    }

    sourceSets {
        getByName("main").apply {
            res.srcDirs(
                "src/main/res-screens/auth",
            )
        }
    }

    signingConfigs {
        create("release") {
            storeFile = file("../gradle/keys/key.jks")
            storePassword = "android"
            keyAlias = "android"
            keyPassword = "android"
        }
    }

    flavorDimensions += listOf("transport", "variant")

    productFlavors {
        create("net") {
            dimension = "transport"
        }
        create("sim") {
            dimension = "transport"
        }
        create("dash") {
            dimension = "variant"
        }
        create("clean") {
            dimension = "variant"
        }
    }

    buildTypes {
        getByName("debug") {
            signingConfig = signingConfigs.getByName("release")
            multiDexEnabled = true
        }

        getByName("release") {
            signingConfig = signingConfigs.getByName("release")
            multiDexEnabled = false

            isMinifyEnabled = true
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro")
        }
    }

    buildFeatures {
        viewBinding = true
    }

    lint {
        checkReleaseBuilds = false
    }
}

dependencies {
    implementation(libs.kotlin.coroutines.core)

    implementation(libs.appCompat)
    implementation(libs.browser)
    implementation(libs.cardView)
    implementation(libs.constraintLayout)
    implementation(libs.gridLayout)
    implementation(libs.core.ktx)
    implementation(libs.fragmentKtx)
    implementation(libs.multidex)
    implementation(libs.recyclerView)

    implementation(libs.lifecycle.liveData)
    implementation(libs.lifecycle.runtime)

    implementation(libs.material)
    implementation(libs.flexbox)

    implementation(libs.fb.core)
    implementation(libs.fb.login)
    implementation(libs.fb.share)

    implementation(libs.twitter)
    implementation(libs.vk)

    implementation(libs.wlog)
    implementation(libs.setupwizard)

    implementation(libs.shimmer)
    implementation(libs.overscrollDecor)

    implementation(libs.acra)

    implementation("com.squareup.okhttp3:okhttp:3.14.9")

    implementation(libs.appauth)

    implementation(libs.navigation.fragment)
    implementation(libs.navigation.ui)

    testImplementation(libs.junit)

    androidTestImplementation(libs.bundles.tests)
    androidTestUtil(libs.test.orchestrator)

    kapt(libs.auto.service)
    compileOnly(libs.service.auto.service.annotations)
}

tasks.whenTaskAdded(closureOf<Task> {
    if(name.startsWith("connectedNet"))
        enabled = false
})

gradle.taskGraph.whenReady {
    this.allTasks.forEach { t ->
        println("Task name = " + t.name + ": ")
        println(t.outputs.files.joinToString())
        println(" ---- done with outputs for " + t.name)
    }
}