package com.tsxentertainment.android.poc.myapplication

import android.os.Bundle
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.activity.compose.BackHandler
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.Button
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.rememberNavController

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            MaterialTheme {
                Surface(Modifier.fillMaxSize()) {
                    val context = LocalContext.current
                    BackHandler {
                        Toast.makeText(context, "This should never ever show!!!", Toast.LENGTH_SHORT).show()
                    }
                    SampleApp()
                }
            }
        }
    }
}

@Composable
fun SampleApp() {
    val navController = rememberNavController()
    NavHost(navController, "first") {
        composable("first") { Screen() }
    }
}

@Composable
fun Screen() {
    val context = LocalContext.current
    BackHandler {
        Toast.makeText(context, "Back clicked", Toast.LENGTH_SHORT).show()
    }
    Column {
        Text("First screen")
    }
}