package com.example.navigationissue

import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.fragment.app.Fragment
import androidx.navigation.NavOptions
import androidx.navigation.fragment.findNavController
import androidx.navigation.navOptions

class SimpleFragment : Fragment(R.layout.fragment_simple) {
    private var popBack = false

    override fun onResume() {
        super.onResume()
        Log.d("SimpleFragment", "onResume")
        // TODO: Comment out to avoid crashes
        if (popBack) {
            navigateToStartFragment()
        }
    }
    override fun onViewCreated(
        view: View,
        savedInstanceState: Bundle?,
    ) {
        Log.d("SimpleFragment", "onViewCreated")

        view.findViewById<View>(R.id.open).setOnClickListener {
            if (!popBack) {
                findNavController().navigate(resId = R.id.navigation_second)
                popBack = true
            } else {
                navigateToStartFragment()
            }
        }
    }

    private fun navigateToStartFragment() {
        val navOptions: NavOptions = navOptions {
            popUpTo(R.id.navigation_start) {
                inclusive = true
            }
        }

        findNavController().navigate(
            resId = R.id.navigation_start,
            args = null,
            navOptions = navOptions,
        )
    }
}
