@Suppress("DSL_SCOPE_VIOLATION") // TODO: Remove once KTIJ-19369 is fixed
plugins {
    alias(libs.plugins.androidLibrary)
    alias(libs.plugins.androidx.baselineprofile)
}

android {
    namespace = "com.example.sdk"
    compileSdk = 33

    defaultConfig {
        minSdk = 28

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        consumerProguardFiles("consumer-rules.pro")
    }

    buildTypes {
        release {
            isMinifyEnabled = true
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }
}

dependencies {
    implementation(libs.androidx.annotation)

    baselineProfile(project(":baseline-profile"))
}

baselineProfile {
    filter {
        include("com.example.sdk.**")
    }
}

// TODO make this task run after generateReleaseBaselineProfile before build
tasks.register<Copy>("copyBaselineProfile") {
    from("src/main/generated/baselineProfiles/baseline-prof.txt")
    into("src/main")
    mustRunAfter("generateReleaseBaselineProfile")
}
