@file:SuppressLint("SetTextI18n")

package com.stevenschoen.composerecyclerviewoverlaycrash

import android.annotation.SuppressLint
import android.os.Bundle
import android.transition.Fade
import android.transition.TransitionManager
import android.view.ViewGroup
import android.view.ViewGroup.LayoutParams.MATCH_PARENT
import android.view.ViewGroup.LayoutParams.WRAP_CONTENT
import android.widget.Button
import android.widget.FrameLayout
import androidx.activity.ComponentActivity
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.ui.platform.ComposeView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.ViewHolder

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val sceneView = FrameLayout(this)
        setContentView(sceneView)

        val recyclerView = RecyclerView(this)

        // You probably won't see this view, because crashy
        val viewB = Button(this).apply { text = "Return to RecyclerView" }

        var isViewBShown = false
        fun reparentAndTransitionViews() {
            TransitionManager.beginDelayedTransition(sceneView, Fade())
            if (isViewBShown) {
                if (recyclerView.parent != null) sceneView.removeView(recyclerView)
                if (viewB.parent == null) sceneView.addView(viewB)
            } else {
                if (recyclerView.parent == null) sceneView.addView(recyclerView)
                if (viewB.parent != null) sceneView.removeView(viewB)
            }
        }

        sceneView.addView(recyclerView)

        viewB.setOnClickListener {
            isViewBShown = false
            reparentAndTransitionViews()
        }

        recyclerView.apply {
            adapter = object : RecyclerView.Adapter<ViewHolder>() {

                override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
                    return object : ViewHolder(
                        ComposeView(parent.context).apply {
                            layoutParams = ViewGroup.LayoutParams(MATCH_PARENT, WRAP_CONTENT)
                            setContent {
                                TextButton(
                                    onClick = {
                                        isViewBShown = true
                                        reparentAndTransitionViews()
                                        recyclerView.smoothScrollToPosition(99999)
                                    }
                                ) {
                                    Text("Click me to crash RV")
                                }
                            }
                        }
                    ) {}
                }

                override fun onBindViewHolder(holder: ViewHolder, position: Int) {
                }

                override fun getItemViewType(position: Int): Int {
                    // Give every item a unique viewType so a new ViewHolder is always created
                    return position
                }

                override fun getItemCount(): Int = 100000

            }
            layoutManager = LinearLayoutManager(context)
        }

        reparentAndTransitionViews()
    }
}
