package com.example.myapplication

import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.fragment.app.DialogFragment
import androidx.lifecycle.LifecycleEventObserver
import androidx.navigation.fragment.findNavController

class Dialog1Fragment : DialogFragment(R.layout.dialog1) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        Log.e("Dialog1Fragment", "onCreate")
        findNavController().getBackStackEntry(R.id.dialog1Fragment).lifecycle
            .addObserver(LifecycleEventObserver { _, event ->
                Log.e("Dialog1Fragment", "Nav lifecycle ${event.name}")
            })
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        Log.e("Dialog1Fragment", "onViewCreated")
        view.findViewById<View>(R.id.button1).setOnClickListener {
            findNavController().popBackStack()
        }
        view.findViewById<View>(R.id.button2).setOnClickListener {
            findNavController().navigate(R.id.action_dialog1Fragment_to_dialog2Fragment)
        }
    }

    override fun onStart() {
        super.onStart()
        Log.e("Dialog1Fragment", "onStart")
    }

    override fun onResume() {
        super.onResume()
        Log.e("Dialog1Fragment", "onResume")
    }

    override fun onPause() {
        super.onPause()
        Log.e("Dialog1Fragment", "onPause")
    }

    override fun onStop() {
        super.onStop()
        Log.e("Dialog1Fragment", "onStop")
    }

    override fun onDestroyView() {
        super.onDestroyView()
        Log.e("Dialog1Fragment", "onDestroyView")
    }

    override fun onDestroy() {
        super.onDestroy()
        Log.e("Dialog1Fragment", "onDestroy")
    }
}
