package com.example.myapplication

import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.fragment.app.DialogFragment
import androidx.lifecycle.LifecycleEventObserver
import androidx.navigation.fragment.findNavController

class Dialog2Fragment : DialogFragment(R.layout.dialog2) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        Log.e("Dialog2Fragment", "onCreate")
        findNavController().getBackStackEntry(R.id.dialog1Fragment).lifecycle
            .addObserver(LifecycleEventObserver { _, event ->
                Log.e("Dialog2Fragment", "Nav lifecycle ${event.name}")
            })
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        Log.e("Dialog2Fragment", "onViewCreated")
        view.findViewById<View>(R.id.button).setOnClickListener {
            findNavController().popBackStack()
        }
    }

    override fun onStart() {
        super.onStart()
        Log.e("Dialog2Fragment", "onStart")
    }

    override fun onResume() {
        super.onResume()
        Log.e("Dialog2Fragment", "onResume")
    }

    override fun onPause() {
        super.onPause()
        Log.e("Dialog2Fragment", "onPause")
    }

    override fun onStop() {
        super.onStop()
        Log.e("Dialog2Fragment", "onStop")
    }

    override fun onDestroyView() {
        super.onDestroyView()
        Log.e("Dialog2Fragment", "onDestroyView")
    }

    override fun onDestroy() {
        super.onDestroy()
        Log.e("Dialog2Fragment", "onDestroy")
    }
}
