package com.pittvandewitt.visibleentriesbugreport

import android.os.Bundle
import android.util.Log
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.lifecycleScope
import androidx.lifecycle.repeatOnLifecycle
import androidx.navigation.fragment.NavHostFragment
import androidx.navigation.ui.AppBarConfiguration
import androidx.navigation.ui.setupActionBarWithNavController
import com.google.android.material.snackbar.Snackbar
import com.pittvandewitt.visibleentriesbugreport.databinding.ActivityMainBinding
import kotlinx.coroutines.launch

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        val navController = binding.navHostFragmentActivityMain.getFragment<NavHostFragment>().navController
        // Passing each menu ID as a set of Ids because each
        // menu should be considered as top level destinations.
        val appBarConfiguration = AppBarConfiguration(
            setOf(
                R.id.navigation_home, R.id.navigation_dashboard, R.id.navigation_notifications
            )
        )
        setupActionBarWithNavController(navController, appBarConfiguration)

        lifecycleScope.launch {
            lifecycle.repeatOnLifecycle(Lifecycle.State.STARTED) {
                navController.visibleEntries.collect {
                    it.contains(navController.getBackStackEntry(R.id.navigation_home))
                    val visibleFragments = it.joinToString {
                        kotlin.runCatching {
                            when (it.id) {
                                navController.getBackStackEntry(R.id.navigation_home).id -> {
                                    "Home"
                                }
                                navController.getBackStackEntry(R.id.navigation_dashboard).id -> {
                                    "Dashboard"
                                }
                                navController.getBackStackEntry(R.id.navigation_notifications).id -> {
                                    "Notifications"
                                }
                                else -> "Unknown"
                            }
                        }.getOrElse { "Crash" }
                    }
                    Log.i("logme", visibleFragments)

                    val isHomeVisible =
                        it.contains(navController.getBackStackEntry(R.id.navigation_home))
                    Snackbar.make(
                        binding.navHostFragmentActivityMain,
                        "Is home visible: $isHomeVisible",
                        Snackbar.LENGTH_SHORT
                    ).show()
                }
            }
        }
    }
}