package com.openrunner.android.navigation26popbackstackissue

import android.os.Bundle
import android.view.View
import androidx.fragment.app.Fragment
import androidx.navigation.fragment.FragmentNavigator
import androidx.navigation.fragment.findNavController
import com.openrunner.android.navigation26popbackstackissue.databinding.FragmentABinding

class FragmentA : Fragment(R.layout.fragment_a) {
    private val binding by viewBinding { FragmentABinding.bind(it) }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        binding.textView.text =
            "A\nCurrent destination :\n${(findNavController().currentDestination as? FragmentNavigator.Destination)?.className?.split(".")?.last()}"

        binding.nextButton.setOnClickListener {
            findNavController().navigate(FragmentADirections.actionFragmentAToFragmentB())
        }
    }
}