package com.openrunner.android.navigation26popbackstackissue

import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.view.View
import androidx.core.os.postDelayed
import androidx.fragment.app.Fragment
import androidx.navigation.fragment.findNavController
import com.openrunner.android.navigation26popbackstackissue.databinding.FragmentBBinding

class FragmentB : Fragment(R.layout.fragment_b) {
    private val binding by viewBinding { FragmentBBinding.bind(it) }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        postponeEnterTransition()

        Handler(Looper.myLooper()!!).postDelayed(1000) {
            startPostponedEnterTransition()
        }

        binding.nextButton.setOnClickListener {
            findNavController().navigate(FragmentBDirections.actionFragmentBToFragmentC())
        }
    }
}