package com.example.navigationtest

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.padding
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Info
import androidx.compose.material3.Icon
import androidx.compose.material3.NavigationBar
import androidx.compose.material3.NavigationBarItem
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.navigation.NavController
import androidx.navigation.NavDestination.Companion.hierarchy
import androidx.navigation.NavHostController
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.currentBackStackEntryAsState
import androidx.navigation.compose.navigation
import androidx.navigation.compose.rememberNavController

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            MyNavHost()
        }
    }
}

@Composable
fun MyNavHost(navController: NavHostController = rememberNavController()) {
    Scaffold(
        bottomBar = { MyNavBar(navController) }
    ) { innerPadding ->
        NavHost(
            modifier = Modifier.padding(innerPadding),
            navController = navController,
            startDestination = "left",
        ) {
            navigation(
                route = "left",
                startDestination = "foo",
            ) {
                composable(route = "foo") {
                    Text("Left")
                }
            }

            navigation(
                route = "right",
                startDestination = "foo",
            ) {
                composable(route = "foo") {
                    Text("Right")
                }
            }
        }
    }
}

@Composable
fun MyNavBar(navController: NavController) {
    val screens = listOf("left", "right")
    val navBackStackEntry by navController.currentBackStackEntryAsState()
    val currentDestination = navBackStackEntry?.destination

    NavigationBar {
        screens.forEach { screen ->
            val selected = currentDestination?.hierarchy?.any { it.route == screen } == true
            NavigationBarItem(
                icon = { Icon(Icons.Default.Info, contentDescription = "") },
                selected = selected,
                label = { Text("text") },
                onClick = {
                    navController.navigate(screen) {
                        launchSingleTop = true
                    }
                }
            )
        }
    }
}
