package com.vulpeszerda.navigation.component.sample

import android.app.Application
import timber.log.Timber

class SampleApplication : Application() {

    override fun onCreate() {
        super.onCreate()
        Timber.plant(object : Timber.DebugTree() {

            override fun log(priority: Int, tag: String?, message: String, t: Throwable?) {
                super.log(priority, listOf(GLOBAL_TAG, tag).joinToString("_"), message, t)
            }
        })
    }

    companion object {

        private const val GLOBAL_TAG = "NavSample"
    }
}
