package com.vulpeszerda.navigation.component.sample.ui.dashboard.nested

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.viewModelScope
import com.vulpeszerda.navigation.component.sample.ui.base.BaseViewModel
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlin.time.Duration.Companion.seconds

class DashboardNestedViewModel : BaseViewModel() {

    private val _text = MutableLiveData<String>().apply {
        value = "This is dashboard nested Fragment"
    }
    val text: LiveData<String> = _text

    init {
        viewModelScope.launch {
            while (true) {
                log("alive")
                delay(3.seconds)
            }
        }
    }

    override fun onCleared() {
        super.onCleared()
        log("cleared")
    }
}
