plugins {
    id("com.android.application")
    id("org.jetbrains.kotlin.android")
}

android {
    namespace = "com.example.resshrinker"

    defaultConfig {
        minSdk = 29
        compileSdk = 33
        targetSdk = 33

        applicationId = "com.example.resshrinker"

        resourceConfigurations += "en"

        versionCode = 1
        versionName = "1.0.0"
    }

    buildTypes {
        create("profiling") {
            signingConfig = getByName("debug").signingConfig
            isDebuggable = false
            isMinifyEnabled = true
            isShrinkResources = true
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
        }
    }

    kotlinOptions {
        compileOptions {
            sourceCompatibility = JavaVersion.VERSION_17
            targetCompatibility = JavaVersion.VERSION_17
        }

        jvmTarget = JavaVersion.VERSION_17.toString()
    }
}

dependencies {
    implementation(project(":sample:library:some-library"))

    implementation("androidx.core:core-ktx:1.10.1")
    implementation("androidx.appcompat:appcompat:1.6.1")
}