package com.example.jumpingtransition

import android.graphics.Color
import android.os.Bundle
import android.view.Gravity
import android.view.ViewGroup
import android.widget.Button
import android.widget.FrameLayout
import androidx.annotation.ColorInt
import androidx.appcompat.app.AppCompatActivity
import androidx.transition.Slide
import androidx.transition.TransitionManager

class MainActivity : AppCompatActivity() {
    private var count = 0

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        findViewById<Button>(R.id.next_button).setOnClickListener {
            switchView()
        }
    }

    private fun switchView() {
        count++

        @ColorInt val color =
            when (count % 6) {
                1 -> { Color.GREEN }
                2 -> { Color.RED }
                3 -> { Color.YELLOW }
                4 -> { Color.GRAY }
                5 -> { Color.MAGENTA }
                else -> { Color.BLUE }
            }

        val container = findViewById<ViewGroup>(R.id.content)

        TransitionManager.beginDelayedTransition(container, Slide(Gravity.START).apply {
            duration = 2000
        })
        container.removeAllViews()
        val layout = FrameLayout(this)
        layout.setBackgroundColor(color)
        container.addView(layout)
    }
}