package com.example.basicmarqueebug

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.ExperimentalFoundationApi
import androidx.compose.foundation.MarqueeAnimationMode
import androidx.compose.foundation.basicMarquee
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.example.basicmarqueebug.ui.theme.BasicMarqueeBugTheme
import kotlinx.coroutines.delay

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            BasicMarqueeBugTheme {
                // A surface container using the 'background' color from the theme
                Surface(
                    modifier = Modifier.fillMaxSize(),
                    color = MaterialTheme.colorScheme.background
                ) {
                    Column {
                        // Show scrolling text
                        var velocity by remember { mutableStateOf(128.dp) }
                        ScrollingText(text = "Hello Android!", velocity = velocity)

                        // Change velocity every 3 second in infinite loop
                        LaunchedEffect(velocity) {
                            delay(3000)
                            velocity += 1.dp
                        }

                        Text(text = "We change velocity every 3s.\n\nExpected behavior: scroll animation will play again.\n\nActual behaviour: every second time the animation stops until the next velocity change.")
                    }
                }
            }
        }
    }
}

@OptIn(ExperimentalFoundationApi::class)
@Composable
fun ScrollingText(text: String, velocity: Dp) {
    Text(
        text = text,
        modifier = Modifier.basicMarquee(
            iterations = Int.MAX_VALUE,
            animationMode = MarqueeAnimationMode.Immediately,
            delayMillis = 0,
            velocity = velocity
        ),
        fontSize = 256.sp
    )
}

@Preview(showBackground = true)
@Composable
fun ScrollingTextPreview() {
    ScrollingText(text = "Hello Android!", 128.dp)
}