package com.example.bugreport

import androidx.compose.foundation.interaction.MutableInteractionSource
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Text
import androidx.compose.material3.TextFieldDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.text.input.VisualTransformation
import androidx.compose.ui.unit.dp

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun BugDemo() {


	VerticalGrid(
		numElems = 5,
		numColumns = 3,
		content =  { _ ->

			/*!!! It works if you remove this column or switch to Box */
			Column {
				TextFieldDefaults.DecorationBox(
					value = "Hats",
					innerTextField = { Text("Cats") },
					enabled = true,
					singleLine = true,
					visualTransformation = VisualTransformation.None,
					interactionSource = remember { MutableInteractionSource() },
					label = null,
					suffix = { Text("Rats") },
					colors = TextFieldDefaults.colors(),
					contentPadding = PaddingValues(horizontal = 2.dp, vertical = 4.dp),
				)
			}

		},
	)

}