package com.example.bugreport

import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.Layout
import androidx.compose.ui.unit.Constraints


@Composable
fun VerticalGrid(
	numElems: Int,
	numColumns: Int,
	modifier: Modifier = Modifier,
	content: @Composable (Int) -> Unit,
) {

	if (numElems == 0) return
	check(numColumns > 1)

	val numCols by remember(numColumns, numElems) { mutableStateOf(minOf(numColumns, numElems)) }
	val numRows by remember(numColumns, numElems) { mutableStateOf((numElems + numCols -1)/numCols) }

	Layout(
		content = {
			repeat(numElems) { content(it) }
		},
		modifier = modifier,
	) { measurables, origConstrs ->


		val mainMeasurables = measurables.take(numElems)


		var constrs = origConstrs.copy(
			maxHeight = if (origConstrs.maxHeight == Constraints.Infinity) Constraints.Infinity
			else origConstrs.maxHeight/numRows
		)


		println("constrs=$constrs \n")

		val itemWidth = mainMeasurables.maxOf { it.maxIntrinsicWidth(constrs.maxHeight) }

		constrs = Constraints(minWidth = itemWidth, maxWidth = itemWidth)

		val mainPlaceables = mainMeasurables.map { it.measure(constrs) }

		val itemHeight = mainPlaceables.maxOf { it.height }



		layout(numCols*itemWidth, numRows*itemHeight) {

			for (i in mainPlaceables.indices) {
				val r = i/numCols
				val c = i%numCols

				val x = c*(itemWidth)
				val y = r*itemHeight

				mainPlaceables[i].placeRelative(x, y)
			}

		}
	}
}