package com.example.bugreport

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.FilledTonalButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.lifecycle.ViewModelProvider
import com.example.bugreport.ui.theme.BugReportTheme


class MainActivity : ComponentActivity() {


	private lateinit var mainVM: MainVM


	override fun onCreate(savedInstanceState: Bundle?) {
		super.onCreate(savedInstanceState)

		mainVM = ViewModelProvider(this)[MainVM::class.java]

		setContent {
			BugReportTheme {
				Surface(
					modifier = Modifier.fillMaxSize(),
					color = MaterialTheme.colorScheme.background
				) {

					Box(
						contentAlignment = Alignment.Center,
						modifier = Modifier
							.fillMaxSize()
					) {


						var isStarted by remember { mutableStateOf(false) }

						if (isStarted)
							BugDemo()
						else
							FilledTonalButton(
								onClick = { isStarted = true },
								content =  { Text(text = "Click to Start") }
							)

					}

				}
			}
		}
	}
}
