plugins {
    id("com.android.application")
    kotlin("android")
}

android {
    namespace = "com.erdenian.dropdownmenuintopappbar"
    compileSdk = 34

    defaultConfig {
        applicationId = "com.erdenian.dropdownmenuintopappbar"
        versionCode = 1
        versionName = "1.0.0"

        minSdk = 21
        targetSdk = 34
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }

    buildFeatures.compose = true
    composeOptions.kotlinCompilerExtensionVersion = "1.5.3"
}

tasks.withType<org.jetbrains.kotlin.gradle.tasks.KotlinCompile> {
    compilerOptions.jvmTarget.set(org.jetbrains.kotlin.gradle.dsl.JvmTarget.JVM_11)
}

dependencies {
    implementation("androidx.appcompat:appcompat:1.6.1")
    implementation("androidx.activity:activity-compose:1.7.2")

    implementation(platform("androidx.compose:compose-bom:2023.09.00"))
    implementation("androidx.compose.material3:material3:1.2.0-alpha07")
}
