package com.example.myapplication


import android.content.res.Resources
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup

import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import androidx.navigation.NavBackStackEntry
import androidx.navigation.fragment.findNavController
import com.example.myapplication.databinding.BottomsheetBinding

import com.google.android.material.bottomsheet.BottomSheetDialogFragment

class BottomSheetFragment: BottomSheetDialogFragment() {

    private var _bottomsheetLayoutBinding:BottomsheetBinding? = null
    private val bottomsheetBinding get() = _bottomsheetLayoutBinding!!
    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _bottomsheetLayoutBinding = BottomsheetBinding.inflate(layoutInflater,container,false)
        return bottomsheetBinding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        bottomsheetBinding.apply {
            coordinatorLayout.minimumHeight = Resources.getSystem().displayMetrics.heightPixels
        }
        bottomsheetBinding.buttonNext.setOnClickListener{
            findNavController().navigate(R.id.dialogueFragments)
        }
        setBackStackEntryObserver()
    }

    private fun setBackStackEntryObserver() {
        val navBackStackEntry: NavBackStackEntry =
            findNavController().getBackStackEntry(R.id.bottomSheetFragment)
        val observer =
            LifecycleEventObserver { _, event ->

                //Lifecycle does not go back to onResume or OnStart after the dialogue closes
                Log.d("TAG", "setBackStackEntryObserver: " +event)


            }

        navBackStackEntry.lifecycle.addObserver(observer)

        // As addObserver() does not automatically remove the observer, we
        // call removeObserver() manually when the view lifecycle is destroyed

        // As addObserver() does not automatically remove the observer, we
        // call removeObserver() manually when the view lifecycle is destroyed
        viewLifecycleOwner.lifecycle.addObserver(LifecycleEventObserver { _, event ->
            if (event == Lifecycle.Event.ON_DESTROY) {
                navBackStackEntry.lifecycle.removeObserver(observer)
            }
        })
    }



}