package de.chris.myapplication

import android.Manifest
import android.app.DownloadManager
import android.content.pm.PackageManager
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.os.Environment
import android.webkit.CookieManager
import android.webkit.URLUtil
import android.webkit.WebSettings
import android.webkit.WebView
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.ui.viewinterop.AndroidView
import de.chris.myapplication.ui.theme.MyApplicationTheme

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val webView = WebView(this)
        val url = "https://webviewcontentdisposition.free.beeceptor.com/download-file"

        setContent {
            MyApplicationTheme {
                AndroidView(factory = {
                    webView.apply {
                        loadUrl(url)

                        setDownloadListener { url, _, contentDisposition, mimetype, _ ->
                            downloadFile(url, mimetype, contentDisposition)
                        }
                    }
                })
            }
        }
    }

    private fun downloadFile(
        url: String,
        mimeType: String,
        contentDisposition: String,
    ) {
        val request = DownloadManager.Request(Uri.parse(url))
        request.setMimeType(mimeType)
        request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED)
        println("ContentDisposition: $contentDisposition")
        request.setDestinationInExternalPublicDir(
            Environment.DIRECTORY_DOWNLOADS,
            // this is the important part where we guess the filename based on the contentDisposition
            URLUtil.guessFileName(url, contentDisposition, mimeType)
        )

        val downloadManager = getSystemService(DOWNLOAD_SERVICE) as DownloadManager
        downloadManager.enqueue(request)
    }
}