package nl.jacobras.longtextcrash

import android.os.Bundle
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.material3.TextField
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableIntStateOf
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.unit.sp
import nl.jacobras.longtextcrash.ui.theme.LongTextCrashTheme

class MainActivity : ComponentActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            LongTextCrashTheme {
                var showText by remember { mutableStateOf(false) }

                var numberOfLines by remember { mutableIntStateOf(5_000) }
                val builder = buildAnnotatedString {
                    repeat(numberOfLines) {
                        withStyle(SpanStyle(fontWeight = FontWeight.Bold, fontSize = 24.sp)) {
                            appendLine("Line $it")
                        }
                    }
                }

                LazyColumn {
                    item {
                        TextField(
                            value = numberOfLines.toString(),
                            onValueChange = { numberOfLines = it.toInt() },
                            label = { Text("Number of lines") }
                        )
                        Text("(= ${builder.length} characters)")
                        Row {
                            Button(onClick = {
                                showToast("Updating, please wait...")
                                showText = !showText
                            }) {
                                Text("${if (showText) "Hide" else "Show"} Text")
                            }
                        }
                    }

                    if (showText) {
                        item { Text(text = builder) }
                    }
                }
            }
        }
    }

    private fun showToast(message: String) {
        Toast.makeText(this, message, Toast.LENGTH_SHORT).show()
    }
}