@file:OptIn(ExperimentalMaterial3AdaptiveNavigationSuiteApi::class,
    ExperimentalMaterial3AdaptiveApi::class
)

package com.robs.shortcuts.ui.composable

import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Icon
import androidx.compose.material3.Text
import androidx.compose.material3.adaptive.ExperimentalMaterial3AdaptiveApi
import androidx.compose.material3.adaptive.currentWindowAdaptiveInfo
import androidx.compose.material3.adaptive.navigation.suite.ExperimentalMaterial3AdaptiveNavigationSuiteApi
import androidx.compose.material3.adaptive.navigation.suite.NavigationSuiteScaffold
import androidx.compose.material3.adaptive.navigation.suite.NavigationSuiteScaffoldDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableIntStateOf
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.robs.shortcuts.ui.theme.RobsShortcutsTheme

@Composable
fun MainUI(navigationItems: List<Item> = defaultNavigationItems) {
    var selectedItem by rememberSaveable { mutableIntStateOf(0) }
    val navSuiteType =
        NavigationSuiteScaffoldDefaults.calculateFromAdaptiveInfo(currentWindowAdaptiveInfo())

    NavigationSuiteScaffold(
        navigationSuiteItems = {
            navigationItems.forEachIndexed { index, navItem ->
                item(
                    icon = { Icon(navItem.icon, contentDescription = navItem.contentDescription) },
                    label = { Text(navItem.text) },
                    selected = selectedItem == index,
                    onClick = { selectedItem = index }
                )
            }
        }
    ) {
        Text(
            modifier = Modifier.padding(16.dp),
            text = "Current NavigationSuiteType: $navSuiteType"
        )
    }
}

@Preview(showBackground = true)
@Composable
fun MainUIPreview() {
    RobsShortcutsTheme {
        MainUI()
    }
}