package com.robs.shortcuts.ui.composable

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Build
import androidx.compose.material.icons.filled.Home
import androidx.compose.material.icons.filled.Search
import androidx.compose.ui.graphics.vector.ImageVector

data class Item(
    val icon: ImageVector,
    val text: String,
    val contentDescription: String = text
)

val defaultNavigationItems = listOf(
    Item(
        icon = Icons.Filled.Build,
        text = "Octoprint"
    ),
    Item(
        icon = Icons.Filled.Home,
        text = "Home"
    ),
    Item(
        icon = Icons.Filled.Search,
        text = "Dashboard"
    )
)
