package com.issue.fragment.state.restoration.inside.compose

import android.os.Bundle
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.viewinterop.AndroidView
import androidx.core.view.ViewCompat
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import androidx.fragment.app.FragmentContainerView
import androidx.fragment.app.commit
import com.issue.fragment.state.restoration.inside.compose.ui.theme.FragmentStateRestorationInsideComposeTheme

class MainActivity : FragmentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            FragmentStateRestorationInsideComposeTheme {
                // A surface container using the 'background' color from the theme
                Surface(modifier = Modifier.fillMaxSize(), color = MaterialTheme.colorScheme.background) {
                    val containerId = rememberSaveable {
                        ViewCompat.generateViewId()
                    }
                    val fragmentTag = rememberSaveable {
                        "FragmentTag$containerId"
                    }
                    AndroidView(factory = { context ->
                        FragmentContainerView(context).apply {
                            id = containerId
                        }
                    }, update = { containerView ->
                        if (containerView.getFragment<Fragment?>() == null) {
                            supportFragmentManager.commit {
                                replace(containerId, SomeFragment(), fragmentTag)
                            }
                        }
                    })
                }
            }
        }
    }
}

@Composable
fun Greeting(name: String, modifier: Modifier = Modifier) {
    Text(
        text = "Hello $name!",
        modifier = modifier
    )
}

@Preview(showBackground = true)
@Composable
fun GreetingPreview() {
    FragmentStateRestorationInsideComposeTheme {
        Greeting("Android")
    }
}
