package com.example.pbfragmentsharedelement

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import androidx.fragment.app.FragmentContainerView
import androidx.navigation.fragment.NavHostFragment
import androidx.navigation.ui.AppBarConfiguration
import androidx.navigation.ui.NavigationUI
import com.google.android.material.appbar.MaterialToolbar

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        val toolbar = findViewById<MaterialToolbar>(R.id.toolbar)
        val navController = findViewById<FragmentContainerView>(R.id.nav_host_fragment).getFragment<NavHostFragment>().navController
        val configuration = AppBarConfiguration(navController.graph)
        NavigationUI.setupWithNavController(toolbar, navController, configuration)
    }
}