//
//  ViewController.m
//  seanet_for_ios
//
//  Created by Brian Clear on 24/01/2024.
//

#import "VCConfiguredInCodeViewController.h"
#import <GoogleMaps/GoogleMaps.h>
@interface VCConfiguredInCodeViewController ()

@property (strong, nonatomic) IBOutlet GMSMapView *mapView;
@property (weak, nonatomic) IBOutlet UIView *mapViewContainer;

@end

@implementation VCConfiguredInCodeViewController
- (void)viewDidAppear:(BOOL)animated{
    // Do any additional setup after loading the view.
    // Create a GMSCameraPosition that tells the map to display the
    // coordinate -33.86,151.20 at zoom level 6.
    GMSMapViewOptions *options = [[GMSMapViewOptions alloc] init];
    options.camera = [GMSCameraPosition cameraWithLatitude:-33.8683
                                                          longitude:151.2086
                                                               zoom:6];
    //options.frame = self.view.bounds;
    //options.frame = self.mapView.bounds;
    //options.frame = self.mapViewContainer.bounds;
    //options.frame = self.mapViewContainer.frame;
    
    options.frame =
        CGRectMake(0.0,
                   0.0,
                   self.mapViewContainer.bounds.size.width,
                   self.mapViewContainer.bounds.size.height);

    self.mapView = [[GMSMapView alloc] initWithOptions:options];

    [self.mapViewContainer addSubview:self.mapView];

    // Creates a marker in the center of the map.
    GMSMarker *marker = [[GMSMarker alloc] init];
    marker.position = CLLocationCoordinate2DMake(-33.86, 151.20);
    marker.title = @"Sydney";
    marker.snippet = @"Australia";
    marker.map = self.mapView;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    
}


@end
