package com.example.navigationbartest

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.animation.EnterTransition
import androidx.compose.animation.ExitTransition
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.AccountCircle
import androidx.compose.material.icons.filled.Home
import androidx.compose.material3.Button
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.NavigationBar
import androidx.compose.material3.NavigationBarItem
import androidx.compose.material3.Scaffold
import androidx.compose.material3.SegmentedButton
import androidx.compose.material3.SegmentedButtonDefaults
import androidx.compose.material3.SingleChoiceSegmentedButtonRow
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableIntStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.navigation.NavDestination.Companion.hierarchy
import androidx.navigation.NavGraph.Companion.findStartDestination
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.currentBackStackEntryAsState
import androidx.navigation.compose.rememberNavController
import com.example.navigationbartest.ui.theme.NavigationBarTestTheme

class MainActivity : ComponentActivity() {
    @OptIn(ExperimentalMaterial3Api::class)
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            NavigationBarTestTheme {
                // A surface container using the 'background' color from the theme
                Surface(
                    modifier = Modifier.fillMaxSize(), color = MaterialTheme.colorScheme.background
                ) {
                    val navController = rememberNavController()
                    val navBackStackEntry by navController.currentBackStackEntryAsState()
                    val currentDestination = navBackStackEntry?.destination

                    Scaffold(bottomBar = {
                        NavigationBar {
                            NavigationBarItem(selected = currentDestination?.hierarchy?.any { it.route == "home" } ?: false, onClick = {
                                navController.navigate("home") {
                                    popUpTo(navController.graph.findStartDestination().id) {
                                        saveState = true
                                    }

                                    launchSingleTop = true
                                    restoreState = true
                                }
                            }, icon = {
                                Icon(
                                    Icons.Filled.Home, contentDescription = "Home"
                                )
                            }, label = { Text(text = "Home") })
                            NavigationBarItem(selected = currentDestination?.hierarchy?.any { it.route == "login" } ?: false, onClick = {
                                navController.navigate("login") {
                                    popUpTo(navController.graph.findStartDestination().id) {
                                        saveState = true
                                    }

                                    launchSingleTop = true
                                    restoreState = true
                                }
                            }, icon = {
                                Icon(
                                    Icons.Filled.AccountCircle, contentDescription = "Login"
                                )
                            }, label = { Text(text = "Login") })
                        }
                    }) { innerPadding ->
                        NavHost(
                            navController = navController, startDestination = "home",
                            enterTransition = { EnterTransition.None },
                            exitTransition = { ExitTransition.None },
                            modifier = Modifier.padding(innerPadding)

                        ) {
                            composable("home") {
                                Column(
                                    horizontalAlignment = Alignment.CenterHorizontally,
                                    verticalArrangement = Arrangement.Center,
                                    modifier = Modifier.fillMaxSize()
                                ) {
                                    SingleChoiceSegmentedButtonRow(
                                        modifier = Modifier
                                            .padding(horizontal = 16.dp)
                                            .fillMaxWidth()
                                    ) {
                                        SegmentedButton(
                                            selected = false,
                                            onClick = { /*TODO*/ },
                                            shape = SegmentedButtonDefaults.baseShape
                                        ) {
                                            Text(text = "Hello, World!")
                                        }

                                        SegmentedButton(
                                            selected = false,
                                            onClick = { /*TODO*/ },
                                            shape = SegmentedButtonDefaults.baseShape
                                        ) {
                                            Text(text = "Hello, World!")
                                        }
                                    }
                                    Text(text = "Home")
                                    Button(onClick = { navController.navigate("login") }) {
                                        Text(text = "Hello, World!")
                                    }
                                    Text(text = "Home")
                                    Button(onClick = { navController.navigate("login") }) {
                                        Text(text = "Hello, World!")
                                    }
                                    Text(text = "Home")
                                    Button(onClick = { navController.navigate("login") }) {
                                        Text(text = "Hello, World!")
                                    }
                                }
                            }
                            composable("login") {
                                Column(
                                    horizontalAlignment = Alignment.CenterHorizontally,
                                    verticalArrangement = Arrangement.Center,
                                    modifier = Modifier.fillMaxSize()
                                ) {
                                    SingleChoiceSegmentedButtonRow(
                                        modifier = Modifier
                                            .padding(horizontal = 16.dp)
                                            .fillMaxWidth()
                                    ) {
                                        SegmentedButton(
                                            selected = false,
                                            onClick = { /*TODO*/ },
                                            shape = SegmentedButtonDefaults.baseShape
                                        ) {
                                            Text(text = "Hello, World!")
                                        }

                                        SegmentedButton(
                                            selected = false,
                                            onClick = { /*TODO*/ },
                                            shape = SegmentedButtonDefaults.baseShape
                                        ) {
                                            Text(text = "Hello, World!")
                                        }
                                    }

                                    Text(text = "Login")
                                    Button(onClick = { navController.navigate("home") }) {
                                        Text(text = "Hello, World!")
                                    }
                                    Text(text = "Home")
                                    Button(onClick = { navController.navigate("home") }) {
                                        Text(text = "Hello, World!")
                                    }
                                    Text(text = "Home")
                                    Button(onClick = { navController.navigate("home") }) {
                                        Text(text = "Hello, World!")
                                    }
                                }
                            }
                        }

                    }
                }
            }
        }
    }
}