package camerax.reproducer

import android.content.Context
import android.graphics.drawable.Icon
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatImageButton
import androidx.camera.core.ImageCapture
import androidx.core.content.ContextCompat
import androidx.core.graphics.drawable.IconCompat

class FlashButton : AppCompatImageButton {
    private var flashState = ImageCapture.FLASH_MODE_OFF

    constructor(context: Context) : super(context)
    constructor(context: Context, attrs: AttributeSet) : super(context, attrs)
    constructor(context: Context, attrs: AttributeSet, defStyleAttribute: Int) : super(context, attrs, defStyleAttribute)

    private val onIcon: Icon = IconCompat.createWithResource(context, R.drawable.ic_arc_flash).toIcon(context)
    private val offIcon: Icon = IconCompat.createWithResource(context, R.drawable.ic_arc_flash_off).toIcon(context)
    private val autoIcon: Icon = IconCompat.createWithResource(context, R.drawable.ic_arc_flash_auto).toIcon(context)

    init {
        update()
    }

    override fun setEnabled(enabled: Boolean) {
        super.setEnabled(enabled)
        val tint = drawableState?.let { imageTintList?.getColorForState(it, ContextCompat.getColor(context, R.color.arc_raw_white)) }
            ?: run { ContextCompat.getColor(context, R.color.arc_raw_white) }

        onIcon.setTint(tint)
        offIcon.setTint(tint)
        autoIcon.setTint(tint)

        if (!enabled) {
            flashState = ImageCapture.FLASH_MODE_OFF
            update()
        }
    }

    fun getFlashMode(): Int {
        return flashState
    }

    fun setFlashMode(mode: Int) {
        flashState = mode
        update()
    }

    private fun update() {
        when (flashState) {
            ImageCapture.FLASH_MODE_ON -> onIcon to "Flash On"
            ImageCapture.FLASH_MODE_OFF -> offIcon to "Flash Off"
            ImageCapture.FLASH_MODE_AUTO -> autoIcon to "Flash Auto"
            else -> offIcon to "Flash Off"
        }.let { (icon, description) ->
            setImageIcon(icon)
            contentDescription = description
        }
    }
}
