package camerax.reproducer

import android.Manifest
import android.content.DialogInterface
import android.content.Intent
import android.content.pm.PackageManager
import android.os.Bundle
import android.widget.Toast
import androidx.activity.result.contract.ActivityResultContracts
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import camerax.reproducer.databinding.MainActivityBinding
import com.google.android.material.snackbar.Snackbar

class MainActivity : AppCompatActivity() {
    lateinit var binding: MainActivityBinding

    val permissions = listOf(Manifest.permission.CAMERA)

    private val requestPermissionLauncher = registerForActivityResult(ActivityResultContracts.RequestMultiplePermissions()) { permissions ->
        when (permissions.all { permission -> permission.value }) {
            true -> {
                val intent = Intent(this, CameraActivity::class.java)
                startActivity(intent)
            }
            false -> handleNoCameraPermissions()
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = MainActivityBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.openCameraButton.setOnClickListener {
            if (ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA) == PackageManager.PERMISSION_GRANTED) {
                startCameraActivity()
            } else {
                requestPermissionLauncher.launch(arrayOf(Manifest.permission.CAMERA))

            }
        }
    }

    private fun handleNoCameraPermissions() {
        if (shouldShowRequestPermissionRationale(Manifest.permission.CAMERA)) {
            AlertDialog.Builder(this).setTitle("Enable Camera").setMessage("If you don't enable camera permissions, we can't take pictures.")
                .setPositiveButton("OK"
                ) { _, _ -> requestPermissionLauncher.launch(arrayOf(Manifest.permission.CAMERA)) }
        }
        else {
            Snackbar.make(binding.root, "Camera Permissions Not Granted", Snackbar.LENGTH_INDEFINITE).show()
        }
    }

    private fun startCameraActivity() {
        val intent = Intent(this, CameraActivity::class.java)
        startActivity(intent)
    }

}
