//
//  MapView.swift
//  Qatar-National
//
//  Created by roopesh.s.tripathi on 06/12/23.
//

import SwiftUI
import GoogleMaps

struct GoogleMapView: UIViewRepresentable {
    var markerPosition: CLLocationCoordinate2D?

    func makeUIView(context: Context) -> GMSMapView {
        let camera = GMSCameraPosition.camera(withLatitude: 37.7749, longitude: -122.4194, zoom: 12.0)
        let options = GMSMapViewOptions()
        options.camera = camera

        let mapView = GMSMapView(options: options)
        return mapView
    }

    func updateUIView(_ uiView: GMSMapView, context: Context) {
        // Remove existing markers
        uiView.clear()

        // Add a marker if a position is provided
        if let position = markerPosition {
            let marker = GMSMarker(position: position)
            marker.title = "Marker Title"
            marker.snippet = "Marker Snippet"
            marker.map = uiView
        }
    }
}

