//
//  StreetView.swift
//  GoogleMapDemo
//
//  Created by Akshay Diliprao Chavan on 17/05/24.
//

import SwiftUI
import GoogleMaps

struct StreetView: UIViewRepresentable {
    let streetViewDetails: StreetViewDetails

    func makeUIView(context: Context) -> GMSPanoramaView {
        let panoramaView = GMSPanoramaView(frame: .zero)
        panoramaView.moveNearCoordinate(CLLocationCoordinate2D(latitude: streetViewDetails.latitude, longitude: streetViewDetails.longitude))
        return panoramaView
    }

    func updateUIView(_ uiView: GMSPanoramaView, context: Context) {
        uiView.moveNearCoordinate(CLLocationCoordinate2D(latitude: streetViewDetails.latitude, longitude: streetViewDetails.longitude))
    }
}



struct StreetViewDetails: Equatable {
    let panoramaId: String
    let latitude: Double
    let longitude: Double
}
