package com.example.paging3

sealed class AdapterItem : StableIdItem {
    abstract fun getItemType(): Type

    enum class Type(val id: Int) {
        Header(100),
        Content(200);

        companion object {
            fun fromId(id: Int): Type {
                return when (id) {
                    100 -> Header
                    200 -> Content
                    else -> throw IllegalArgumentException("No item type found for id: $id")
                }
            }
        }
    }


    data class Content(val note: Note) : AdapterItem() {
        override fun getItemType() = Type.Content
        override fun getStableID() = note.id
    }

    data class Header(val header: NoteHeader) : AdapterItem() {
        override fun getItemType() = Type.Header
        override fun getStableID() = header.hashCode().toLong()
    }
}