package com.example.paging3

import androidx.paging.PagingSource

abstract class InvalidatingPagingSource<Key : Any, Value : Any>(factory: (Invalidator) -> Unit) : PagingSource<Key, Value>() {

    override val jumpingSupported = true

    init {
        factory.invoke(object : Invalidator {
            override fun invalidateNow(source: String) {

                invalidate()
            }

        })
    }

    interface Invalidator {
        fun invalidateNow(source: String)
    }
}