package com.example.paging3

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.paging.PagingDataAdapter
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView
import com.example.paging3.databinding.NoteHeaderBinding
import com.example.paging3.databinding.NoteItemBinding

class NotesAdapterPaging : PagingDataAdapter<AdapterItem, RecyclerView.ViewHolder>(DiffCallback) {

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {

        when (val item = getItem(position)) {
            is AdapterItem.Content -> {
                (holder as NoteViewHolder).bind(item)
            }

            is AdapterItem.Header -> {
                (holder as NoteHeaderViewHolder).bind(item)
            }

            null -> throw IllegalArgumentException("Item at $position was NULL!!!. This should only happen if enablePlaceholders was true")
        }
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int) = when (AdapterItem.Type.fromId(viewType)) {
        AdapterItem.Type.Content -> {
            val binding = NoteItemBinding.inflate(LayoutInflater.from(parent.context), parent, false)
            NoteViewHolder(binding)
        }

        AdapterItem.Type.Header -> {
            val binding = NoteHeaderBinding.inflate(LayoutInflater.from(parent.context), parent, false)
            NoteHeaderViewHolder(binding)
        }


    }

    override fun getItemViewType(position: Int): Int {
        return when (val item = peek(position)) {
            is AdapterItem -> item.getItemType().id
            else -> throw IllegalArgumentException("Null item")
        }
    }

    object DiffCallback : DiffUtil.ItemCallback<AdapterItem>() {
        override fun areItemsTheSame(oldItem: AdapterItem, newItem: AdapterItem): Boolean {
            return oldItem.getStableID() == newItem.getStableID()
        }

        override fun areContentsTheSame(oldItem: AdapterItem, newItem: AdapterItem): Boolean {
            return oldItem == newItem
        }

    }

    class NoteViewHolder(private val binding: NoteItemBinding) : RecyclerView.ViewHolder(binding.root) {
        fun bind(item: AdapterItem.Content) {
            binding.note.text = item.note.note
        }
    }

    class NoteHeaderViewHolder(private val binding: NoteHeaderBinding) : RecyclerView.ViewHolder(binding.root) {
        fun bind(item: AdapterItem.Header) {
            binding.noteHeader.text = item.header.headerTitle
        }

    }
}
